package kom.itbeankit.common.message;

import java.util.*;
public class MessageEvent extends java.util.EventObject
{
    //where should the message been displayed
    public static final int MSG_BEGIN              = 700;
    public static final int DISPLAY_TYPE_TEXTAREA  = MSG_BEGIN+1;
    public static final int DISPLAY_TYPE_DIALOG    = MSG_BEGIN+2;
    public static final int DISPLAY_TYPE_BOTH      = MSG_BEGIN+3;

    //type of messages
    public static final int MSG_TYPE_INFO           = MSG_BEGIN+10;
    public static final int MSG_TYPE_WARNING        = MSG_BEGIN+11;
    public static final int MSG_TYPE_ERROR          = MSG_BEGIN+12;
    public static final int MSG_TYPE_QUESTION       = MSG_BEGIN+13;
    public static final int MSG_TYPE_ABOUT          = MSG_BEGIN+14;

    protected int displayType   = DISPLAY_TYPE_TEXTAREA;
    protected int msgType       = MSG_TYPE_INFO;
    protected String msgSource  = "";
    protected String msg        = "";

    public MessageEvent(Object source,
                        int displayType,
                        int msgType,
                        String msgSource,
                        String msg){
        super(source);
        this.displayType    = displayType;
        this.msgType        = msgType;
        this.msgSource      = msgSource;
        this.msg            = msg;
    }
    public MessageEvent(Object source,
                        MessageEvent me){
        super(source);
        this.displayType    = me.getDisplayType();
        this.msgType        = me.getMsgType();
        this.msgSource      = me.getMsgSource();
        this.msg            = me.getMsg();
    }

    public int getDisplayType(){
        return displayType;
    }

    public void setdisplayType(int displayType){
        this.displayType = displayType;
    }

    public int getMsgType(){
        return msgType;
    }

    public void setMsgType(int msgType){
        this.msgType = msgType;
    }

    public String getMsgSource(){
        return msgSource;
    }

    public void setMsgSource(String msgSource){
        this.msgSource = msgSource;
    }

    public String getMsg(){
        return msg;
    }

    public void setMsg(String msg){
        this.msg = msg;
    }
}